
---------------------------------------Crafts
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:fifty_pence',
	recipe = {"default:sword_steel", "default:gold_ingot"},
	replacements = {{"default:sword_steel", "default:sword_steel"}, {"hbm:gold_plate", "hbm:round_cut_gold_plate"}}
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:one_gbp',
	recipe = {"gbp_currency:fifty_pence", "gbp_currency:fifty_pence"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:five_gbp',
	recipe = {"gbp_currency:one_gbp", "gbp_currency:one_gbp", "gbp_currency:one_gbp", "gbp_currency:one_gbp", "gbp_currency:one_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:ten_gbp',
	recipe = {"gbp_currency:five_gbp", "gbp_currency:five_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:twenty_gbp',
	recipe = {"gbp_currency:ten_gbp", "gbp_currency:ten_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:fifty_gbp',
	recipe = {"gbp_currency:ten_gbp", "gbp_currency:ten_gbp", "gbp_currency:ten_gbp", "gbp_currency:ten_gbp", "gbp_currency:ten_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:hundred_gbp',
	recipe = {"gbp_currency:fifty_gbp", "gbp_currency:fifty_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:five_hundred_gbp',
	recipe = {"gbp_currency:hundred_gbp", "gbp_currency:hundred_gbp", "gbp_currency:hundred_gbp", "gbp_currency:hundred_gbp", "gbp_currency:hundred_gbp"},
})

----------------------------------------Crafts 2

minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:fifty_pence 2',
	recipe = {"gbp_currency:one_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:one_gbp 5',
	recipe = {"gbp_currency:five_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:five_gbp 2',
	recipe = {"gbp_currency:ten_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:ten_gbp 2',
	recipe = {"gbp_currency:twenty_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:ten_gbp 5',
	recipe = {"gbp_currency:fifty_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:fifty_gbp 2',
	recipe = {"gbp_currency:hundred_gbp"},
})
minetest.register_craft({
	type = "shapeless",
	output = 'gbp_currency:hundred_gbp 5',
	recipe = {"gbp_currency:five_hundred_gbp"},
})
----------------------
----------------------
----------------------
----------------------
-- Initialize player balances
local player_balances = {}

-- Function to create rainbow text
local function rainbow_text(text)
    local colors = {"#1F9434FF", "#1F9434FF", "#1F9434FF", "#1F9434FF", "#1F9434FF", "#1F9434FF", "#1F9434FF"}
    local rainbow = ""
    for i = 1, #text do
        local color = colors[(i - 1) % #colors + 1]
        rainbow = rainbow .. minetest.colorize(color, text:sub(i, i))
    end
    return rainbow
end

-- Function to save balances to a file
local function save_balances()
    local file = io.open(minetest.get_worldpath() .. "/player_balances.txt", "w")
    if file then
        for player_name, balance in pairs(player_balances) do
            file:write(player_name .. " " .. balance .. "\n")
        end
        file:close()
    end
end

-- Function to load balances from a file
local function load_balances()
    local file = io.open(minetest.get_worldpath() .. "/player_balances.txt", "r")
    if file then
        for line in file:lines() do
            local player_name, balance = line:match("([^ ]+) ([0-9]+)")
            if player_name and balance then
                player_balances[player_name] = tonumber(balance)
            end
        end
        file:close()
    end
end

-- Load balances when the mod is initialized
load_balances()

-- Function to add to player's balance
local function add_to_balance(player_name, amount)
    player_balances[player_name] = (player_balances[player_name] or 0) + amount
    local message = "Your balance is now: " .. player_balances[player_name] .. " GBP."
    minetest.chat_send_player(player_name, rainbow_text(message))
    save_balances()  -- Save balances after modification
end

-- Function to check balance
local function check_balance(name)
    return player_balances[name] or 0
end

-- Command to check balance
minetest.register_chatcommand("balance", {
    description = "Check your balance or another player's balance",
    params = "<playername>",
    func = function(name, param)
        local balance
        if param and param ~= "" then
            balance = check_balance(param)
            return true, rainbow_text(param .. "'s balance is: " .. balance .. " GBP")
        else
            balance = check_balance(name)
            return true, rainbow_text("Your balance is: " .. balance .. " GBP")
        end
    end,
})

-- Function to show leaderboard in a GUI
local function show_leaderboard(player_name)
    local sorted_players = {}
    for player, balance in pairs(player_balances) do
        table.insert(sorted_players, {name = player, balance = balance})
    end
    table.sort(sorted_players, function(a, b) return a.balance > b.balance end)

    local message = "Leaderboard:\n"
    for i = 1, math.min(15, #sorted_players) do
        message = message .. i .. ". " .. sorted_players[i].name .. ": " .. sorted_players[i].balance .. " GBP\n"
    end

    minetest.show_formspec(player_name, "gbp_currency:leaderboard", "size[8,6]" ..
        "label[0,0;" .. message .. "]" ..
        "button_exit[3,5;2,1;close;Close]")
end

-- Command to show leaderboard
minetest.register_chatcommand("leaderboard", {
    description = "Show the top 15 richest players",
    func = function(name)
        show_leaderboard(name)
    end,
})

-- Function to handle left-click deposit (one item)
local function deposit_item(user, itemstack)
    local item_name = itemstack:get_name()
    local amount = 0

    if item_name == "gbp_currency:one_gbp" then
        amount = 1
    elseif item_name == "gbp_currency:five_gbp" then
        amount = 5
    elseif item_name == "gbp_currency:ten_gbp" then
        amount = 10
    elseif item_name == "gbp_currency:twenty_gbp" then
        amount = 20
    elseif item_name == "gbp_currency:fifty_gbp" then
        amount = 50
    elseif item_name == "gbp_currency:hundred_gbp" then
        amount = 100
    elseif item_name == "gbp_currency:five_hundred_gbp" then
        amount = 500
    elseif item_name == "gbp_currency:fifty_pence" then
        amount = 0.5
    elseif item_name == "gbp_currency:one_pound" then
        amount = 1
    end

    if amount > 0 then
        add_to_balance(user:get_player_name(), amount)
        itemstack:take_item()  -- Remove one item from inventory
        local message = "You have deposited " .. amount .. " GBP."
        minetest.chat_send_player(user:get_player_name(), rainbow_text(message))
    end
    return itemstack
end

-- Function to handle right-click deposit (whole stack)
local function deposit_stack(user, itemstack)
    local amount = 0
    local item_name = itemstack:get_name()

    if item_name == "gbp_currency:one_gbp" then
        amount = 1 * itemstack:get_count()
    elseif item_name == "gbp_currency:five_gbp" then
        amount = 5 * itemstack:get_count()
    elseif item_name == "gbp_currency:ten_gbp" then
        amount = 10 * itemstack:get_count()
    elseif item_name == "gbp_currency:twenty_gbp" then
        amount = 20 * itemstack:get_count()
    elseif item_name == "gbp_currency:fifty_gbp" then
        amount = 50 * itemstack:get_count()
    elseif item_name == "gbp_currency:hundred_gbp" then
        amount = 100 * itemstack:get_count()
    elseif item_name == "gbp_currency:five_hundred_gbp" then
        amount = 500 * itemstack:get_count()
    elseif item_name == "gbp_currency:fifty_pence" then
        amount = 0.5 * itemstack:get_count()
    elseif item_name == "gbp_currency:one_pound" then
        amount = 1 * itemstack:get_count()
    end

    if amount > 0 then
        add_to_balance(user:get_player_name(), amount)
        itemstack:clear()  -- Remove the entire stack from inventory
        local message = "You have deposited " .. amount .. " GBP."
        minetest.chat_send_player(user:get_player_name(), rainbow_text(message))
    end
    return itemstack
end

-- Register item usage for left-click (on_use)
minetest.register_craftitem("gbp_currency:one_gbp", {
    description = "£1 Note",
    inventory_image = "GBP1.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

-- Repeat for other currency items
minetest.register_craftitem("gbp_currency:five_gbp", {
    description = "£5 Note",
    inventory_image = "GBP5.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:ten_gbp", {
    description = "£10 Note",
    inventory_image = "GBP10.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:twenty_gbp", {
    description = "£20 Note",
    inventory_image = "GBP20.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:fifty_gbp", {
    description = "£50 Note",
    inventory_image = "GBP50.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:hundred_gbp", {
    description = "£100 Note",
    inventory_image = "GBP100.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:five_hundred_gbp", {
    description = "£500 Note",
    inventory_image = "GBP500.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:fifty_pence", {
    description = "50 Pence Coin",
    inventory_image = "50_cents.png",
    on_use = function(itemstack, user, pointed_thing)
        return deposit_item(user, itemstack)
    end,
})

-- Register right-click (on_secondary_use) for depositing the whole stack
minetest.register_craftitem("gbp_currency:one_gbp", {
    description = "£1 Note",
    inventory_image = "GBP1.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

-- Repeat for other currency items
minetest.register_craftitem("gbp_currency:five_gbp", {
    description = "£5 Note",
    inventory_image = "GBP5.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:ten_gbp", {
    description = "£10 Note",
    inventory_image = "GBP10.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:twenty_gbp", {
    description = "£20 Note",
    inventory_image = "GBP20.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:fifty_gbp", {
    description = "£50 Note",
    inventory_image = "GBP50.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:hundred_gbp", {
    description = "£100 Note",
    inventory_image = "GBP100.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:five_hundred_gbp", {
    description = "£500 Note",
    inventory_image = "GBP500.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})

minetest.register_craftitem("gbp_currency:fifty_pence", {
    description = "50 Pence Coin",
    inventory_image = "50_cents.png",
    on_secondary_use = function(itemstack, user, pointed_thing)
        return deposit_stack(user, itemstack)
    end,
})
-- Command to withdraw money
minetest.register_chatcommand("withdraw", {
    description = "Withdraw money",
    func = function(name)
        minetest.show_formspec(name, "gbp_currency:withdraw", "size[8,6]" ..
            "label[0,0;Select the amount to withdraw:]" ..
            "button[0,1;2,1;gbp_currency:fifty_pence;50p]" ..
            "button[2,1;2,1;gbp_currency:one_gbp;£1]" ..
            "button[4,1;2,1;gbp_currency:five_gbp;£5]" ..
            "button[6,1;2,1;gbp_currency:ten_gbp;£10]" ..
            "button[0,3;2,1;gbp_currency:twenty_gbp;£20]" ..
            "button[2,3;2,1;gbp_currency:fifty_gbp;£50]" ..
            "button[4,3;2,1;gbp_currency:hundred_gbp;£100]" ..
            "button[6,3;2,1;gbp_currency:five_hundred_gbp;£500]" ..
            "button_exit[3,5;2,1;close;Close]")  -- Add a close button
    end,
})

-- Handle the withdrawal button clicks
minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname == "gbp_currency:withdraw" then
        local player_name = player:get_player_name()
        for note, _ in pairs(fields) do
            local amount = 0
            if note == "gbp_currency:fifty_pence" then amount = 0.5
            elseif note == "gbp_currency:one_gbp" then amount = 1
            elseif note == "gbp_currency:five_gbp" then amount = 5
            elseif note == "gbp_currency:ten_gbp" then amount = 10
            elseif note == "gbp_currency:twenty_gbp" then amount = 20
            elseif note == "gbp_currency:fifty_gbp" then amount = 50
            elseif note == "gbp_currency:hundred_gbp" then amount = 100
            elseif note == "gbp_currency:five_hundred_gbp" then amount = 500
            end

            -- Withdraw the amount from balance
            local current_balance = check_balance(player_name)
            if current_balance >= amount then
                add_to_balance(player_name, -amount)  -- Deduct from balance
                player:get_inventory():add_item("main", note)  -- Add item to inventory
                minetest.chat_send_player(player_name, rainbow_text("You have withdrawn " .. amount .. " GBP."))
            else
                minetest.chat_send_player(player_name, rainbow_text("Insufficient balance."))
            end
        end
    end
end)

-- Save balances on shutdown
minetest.register_on_shutdown(function()
    save_balances()
end)
----------------------
----------------------
----------------------
----------------------
----------------------
-- Command to transfer money
minetest.register_chatcommand("transfer", {
    params = "<playername> <amount>",
    description = "Transfer money to another player (or yourself)",
    func = function(name, param)
        local target, amount = string.match(param, "^(%S+)%s(%d+)$")
        amount = tonumber(amount)
        if not target or not amount then
            return false, "Invalid parameters. Usage: /transfer <playername> <amount>"
        end

        if not minetest.get_player_by_name(target) and target ~= name then
            return false, "Player " .. target .. " is not online."
        end

        if player_balances[name] and player_balances[target] and player_balances[name] >= amount then
            player_balances[name] = player_balances[name] - amount
            player_balances[target] = player_balances[target] + amount
            save_balances()
            return true, "Transferred " .. amount .. " GBP to " .. target
        else
            return false, "Transfer failed. Check the target player and your balance."
        end
    end
})
